--This return function is used to
-- retrieve the soundID from the global function contained in the file ZomboWinAnimationAddonSFXBackgroundShared.lua
-- then start the sound named ZomboLewdSFXBackground which will be played in a loop
-- and stores the soundID of the sound named ZomboLewdSFXBackground in the global value for its future shutdown

--Note : require must have as path relative to the directory 'client' or 'shared' a / between the directory ZomboWin and ZomboWinAnimationAddonSFXBackgroundShared
-- and especially not a .  ("ZomboWin.ZomboWinAnimationAddonSFXBackgroundShared" will give an error 'attempted index: soundID of non-table')

return function(action, parameter)
    local success, shared = pcall(require, "ZomboWin/ZomboWinAnimationAddonSFXBackgroundShared")
    if not success then
        print("[ZomboWinAddon] Failed to require ZomboWinAnimationAddonSFXBackgroundShared")
        return
    end

    local player = action and action.getCharacter and action:getCharacter() or getPlayer()
    if player then
        local soundID = player:playSound("ZomboLewdSFXBackground")
        table.insert(shared.soundIDs, soundID) -- Add to list
        print("[ZomboWinAddon] Sound started with ID: ", soundID)
    end
end